<?php
namespace App\Mailer\Transport;

use Cake\Mailer\AbstractTransport;
use Cake\Mailer\Message;

class RedirectTransport extends AbstractTransport
{
    public function send(Message $message): array
    {
        $redirectTo = $this->config()['redirect_to'] ?? null;
        if (!$redirectTo) {
            throw new \RuntimeException('RedirectTransport: missing redirect_to');
        }

        // 记录原始收件人
        $origTo = array_keys((array)$message->getTo());
        $origCc = array_keys((array)$message->getCc());
        $origBcc= array_keys((array)$message->getBcc());

        // 改写收件人
        $message
            ->setTo([$redirectTo => 'Mail Sandbox'])
            ->setCc([])
            ->setBcc(array_unique(array_merge($origTo, $origCc, $origBcc)))
            ->addHeaders([
                'X-Original-To' => implode(',', $origTo),
                'X-Original-Cc' => implode(',', $origCc),
            ])
            ->setSubject('[SANDBOX] ' . $message->getSubject());

        // 委托给真正的 SMTP（已在 config 中声明）
        $inner = $this->getTransport($this->config()['inner'] ?? 'cpanel_smtps');
        return $inner->send($message);
    }
}
