<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class ClinicLocationsTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('clinic_locations');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');

        $this->belongsTo('Clinics', [
            'foreignKey' => 'clinic_id',
            'joinType' => 'INNER',
        ]);
    }

    public function validationDefault(Validator $v): Validator
    {
        return $v
            ->integer('clinic_id')->requirePresence('clinic_id')->notEmptyString('clinic_id')
            ->allowEmptyString('street')
            ->allowEmptyString('suburb')
            ->allowEmptyString('state')
            ->allowEmptyString('postcode')
            ->allowEmptyString('country')
            ->boolean('is_primary');
    }
}
