<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class ParticipantAlertsTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('participant_alerts');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');

        $this->belongsTo('Participants', [
            'foreignKey' => 'participant_id',
            'joinType' => 'INNER',
        ]);
    }

    public function validationDefault(Validator $v): Validator
    {
        return $v
            ->integer('participant_id')->requirePresence('participant_id')->notEmptyString('participant_id')
            ->scalar('text')->requirePresence('text')->notEmptyString('text')
            ->scalar('color_hex')->maxLength('color_hex', 7)->regex('color_hex', '/^#[0-9A-Fa-f]{6}$/')
            ->scalar('severity')->maxLength('severity', 16);
    }

    public function findActive(SelectQuery $q, array $options)
    {
        $now = new \DateTimeImmutable('now');
        return $q
            ->where([
                'OR' => [
                    'starts_at IS' => null,
                    'starts_at <=' => $now,
                ],
            ])
            ->where([
                'OR' => [
                    'ends_at IS' => null,
                    'ends_at >=' => $now,
                ],
            ])
            ->where(['dismissed_at IS' => null]);
    }
}
