<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class RemindersTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('reminders');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');

        $this->belongsTo('CalendarEvents', [
            'foreignKey' => 'calendar_event_id',
            'joinType' => 'INNER',
        ]);
    }

    public function validationDefault(Validator $validator): Validator
    {
        return $validator
            ->integer('calendar_event_id')->requirePresence('calendar_event_id', 'create')->notEmptyString('calendar_event_id')
            ->email('to_email')->requirePresence('to_email', 'create')->notEmptyString('to_email')
            ->scalar('template')->maxLength('template', 50)->notEmptyString('template')
            ->integer('offset_minutes')->allowEmptyString('offset_minutes')
            ->dateTime('send_at')->requirePresence('send_at', 'create')->notEmptyDateTime('send_at')
            ->scalar('status')->maxLength('status', 20)->notEmptyString('status');
    }
}
