<?php
/**
 * @var \Cake\Datasource\ResultSetInterface|\App\Model\Entity\Login[] $clinicians
 * @var int    $perPage
 * @var string $q
 */
$this->assign('title', 'Clinicians');

use Cake\Collection\Collection;
?>
<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-header" style="align-items:center;gap:12px;">
                        <h4 class="mb-0">Clinicians</h4>

                        <form class="form-inline ml-auto" method="get" action="">
                            <div class="input-group">
                                <input type="search" name="q" class="form-control"
                                       placeholder="Search keywords"
                                       value="<?= h($q ?? '') ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="submit">Search</button>
                                </div>
                            </div>

                            <div class="ml-2">
                                <select name="limit" class="form-control" onchange="this.form.submit()">
                                    <?php foreach ([10,20,50,100] as $n): ?>
                                        <option value="<?= $n ?>" <?= (int)($perPage ?? 20) === $n ? 'selected':'' ?>>
                                            <?= $n ?> rows
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <a class="btn btn-primary ml-2"
                               href="<?= $this->Url->build(['controller' => 'ClinicianRegister', 'action' => 'index']) ?>">Add Clinician</a>
                        </form>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                <tr>
                                    <th><?= $this->Paginator->sort('Logins.id','ID') ?></th>
                                    <th><?= $this->Paginator->sort('Logins.first_name','First Name') ?></th>
                                    <th><?= $this->Paginator->sort('Logins.last_name','Last Name') ?></th>
                                    <th><?= $this->Paginator->sort('Logins.email','Email') ?></th>
                                    <th><?= $this->Paginator->sort('Logins.mobile_phone','Phone') ?></th>
                                    <th><?= $this->Paginator->sort('specializations_list', 'Specializations') ?></th>
                                    <?php if (!empty($isAdmin) && $isAdmin): ?>
                                        <th class="text-right">Actions</th>
                                    <?php endif; ?>
                                </tr>
                                </thead>

                                <tbody>
                                <?php if (!empty($clinicians) && count($clinicians)): ?>

                                    <?php foreach ($clinicians as $c): ?>
                                        <?php
                                        $rowAttrs = '';
                                        if (!empty($isAdmin) && $isAdmin) {
                                            $rowAttrs = sprintf(
                                                ' class="js-row-link" data-href="%s"',
                                                $this->Url->build(['controller' => 'Clinician','action'=>'profile','?' => ['id' => $c->id]])
                                            );
                                        }
                                        ?>
                                        <tr<?= $rowAttrs ?>>
                                            <td class="text-muted"><?= (int)$c->id ?></td>
                                            <td><?= h($c->first_name) ?></td>
                                            <td><?= h($c->last_name) ?></td>
                                            <td><?= h($c->email) ?></td>
                                            <td><?= h($c->mobile_phone) ?></td>
                                            <td>
                                                <?php
                                                if (!empty($c->specializations)) {
                                                    $names = (new \Cake\Collection\Collection($c->specializations))
                                                        ->extract('name')->toList();
                                                    echo h(implode(', ', $names));
                                                } else {
                                                    echo '—';
                                                }
                                                ?>
                                            </td>
                                            <?php if (!empty($isAdmin) && $isAdmin): ?>
                                                <td class="text-right">
                                                    <?= $this->Form->postLink(
                                                        '<i class="fas fa-trash-alt"></i> Delete',
                                                        ['action' => 'delete', $c->id],
                                                        ['escape' => false, 'class' => 'btn btn-sm btn-outline-danger ml-1',
                                                            'confirm' => 'Delete this clinician? This cannot be undone.']
                                                    ) ?>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>

                                <?php else: ?>

                                    <tr>
                                        <td colspan="<?= !empty($isAdmin) && $isAdmin ? 7 : 6 ?>"
                                            class="text-center text-muted">No data</td>
                                    </tr>

                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-between align-items-center">
                        <div class="text-muted small">
                            Page <?= $this->Paginator->counter('{{page}}') ?> of
                            <?= $this->Paginator->counter('{{pages}}') ?>,
                            showing <?= $this->Paginator->counter('{{current}}') ?> record(s)
                            out of <?= $this->Paginator->counter('{{count}}') ?> total
                        </div>
                        <div>
                            <?= $this->Paginator->prev('« Prev', ['class'=>'btn btn-light btn-sm'], null,
                                ['class'=>'btn btn-light btn-sm disabled']) ?>
                            <?= $this->Paginator->numbers(['class'=>'pagination pagination-sm mb-0', 'currentTag'=>'span']) ?>
                            <?= $this->Paginator->next('Next »', ['class'=>'btn btn-light btn-sm'], null,
                                ['class'=>'btn btn-light btn-sm disabled']) ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<?php if (!empty($isAdmin) && $isAdmin): ?>
    <style>
        tr.js-row-link { cursor: pointer; }
        tr.js-row-link:hover { background: #fbfbfd; }
    </style>
    <script>
        document.querySelectorAll('tr.js-row-link').forEach(function (tr) {
            tr.addEventListener('click', function (e) {
                // don't navigate if the click is on buttons/links inside the Actions cell
                if (e.target.closest('a, button, .btn, input')) return;
                const href = tr.getAttribute('data-href');
                if (href) window.location.assign(href);
            });
        });
    </script>
<?php endif; ?>
