<?php
/**
 * View: Clinician Profile (Halaxy-like)
 * Expects: $user (\App\Model\Entity\Login), $isAdmin (bool)
 */
$identity = $this->request->getAttribute('identity');
$isAdmin  = $identity && strtolower((string)($identity->get('role') ?? '')) === 'admin';


$initials = strtoupper(
    mb_substr((string)$user->first_name, 0, 1) .
    mb_substr((string)$user->last_name, 0, 1)
);
?>
<style>
    .avatar-circle {
        width: 56px;
        aspect-ratio: 1 / 1;  /* Always a square */
        border-radius: 50%;
        background: #576cdf;
        color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 20px;
        flex-shrink: 0; /* prevent shrinking in flexbox */
    }
</style>

    <?= $this->Flash->render() ?>
<div class="card p-3 mb-4 d-flex flex-row justify-content-between align-items-center">
    <h1 class="mb-0">
        Profile: <?= h($user->first_name . ' ' . $user->last_name) ?>
    </h1>

    <?php
    $canEditOwn = $identity && (int)$identity->getIdentifier() === (int)$user->id;
    if ($isAdmin || $canEditOwn): ?>
        <a class="btn btn-primary ml-3 align-self-center"
           href="<?= $this->Url->build([
               'controller' => 'Clinician',
               'action'     => 'edit',
               $user->id,
               '?'          => ['return' => 'profile', 'id' => $user->id] // <-- important for going back
           ]) ?>">
            Edit Profile
        </a>
    <?php endif; ?>
</div>

<div class="row">
    <div class="col-12 col-lg-6">
        <div class="card shadow-sm mb-4">
            <div class="card-body d-flex align-items-center">
                <div class="avatar-circle mr-3"><?= h(strtoupper(mb_substr($user->first_name,0,1).mb_substr($user->last_name,0,1))) ?></div>
                <h2 class="mb-0 h4"><?= h($user->first_name . ' ' . $user->last_name) ?></h2>
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item py-3">
                    <h4 class="text-muted mb-1">Contact Email</h4>
                    <h5 class="fw-medium"><?= h($user->email) ?></h5>
                </li>
            </ul>
            <ul class="list-group list-group-flush">
                <li class="list-group-item py-3">
                    <div class="card-body pt-0">
                        <a class="btn btn-outline-secondary"
                           href="<?= $this->Url->build(['action' => 'changePassword']) ?>">Change Password</a>
                    </div>
                </li>
            </ul>
        </div>
    </div>

    <div class="col-12 col-lg-6">
        <div class="card shadow-sm mb-4">
            <div class="card-header">
                <h5 class="mb-0">Emergency Contact (optional)</h5>
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">
                    <div class="small text-muted mb-1">Name</div>
                    <div class="fw-medium">
                        <?= $user->emergency_name ? h($user->emergency_name) : '—' ?>
                    </div>
                </li>
                <li class="list-group-item">
                    <div class="small text-muted mb-1">Email</div>
                    <div class="fw-medium">
                        <?= $user->emergency_email ? h($user->emergency_email) : '—' ?>
                    </div>
                </li>
                <li class="list-group-item">
                    <div class="small text-muted mb-1">Phone</div>
                    <div class="fw-medium">
                        <?= $user->emergency_phone ? h($user->emergency_phone) : '—' ?>
                    </div>
                </li>
            </ul>
            <div class="card-body">
                <a class="btn btn-primary"
                   href="<?= $this->Url->build(['controller' => 'Clinician', 'action' => 'edit', $user->id, '?' => ['return' => 'profile', 'id' => $user->id]]) ?>">
                    Edit Emergency Contact
                </a>
            </div>
        </div>
    </div>
</div>

<style>
    .avatar-circle{
        width:56px;height:56px;border-radius:50%;
        background:#576cdf;color:#fff;font-weight:700;font-size:20px;
        display:flex;align-items:center;justify-content:center
    }
</style>
