<?php $bg = $this->Url->image('login/background.jpg'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Welcome!</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />



    <?= $this->Html->css(['app.min', 'style', 'components', 'custom']) ?>
    <?= $this->Html->meta('icon') ?>

    <style>
        .card { box-shadow: 0 6px 18px rgba(0,0,0,.05); border: 0; border-radius: 12px; }
        .password-wrapper { position: relative; }
        .password-toggle {
            position: absolute; right: 10px; top: 50%; transform: translateY(-50%);
            border: 0; background: transparent; padding: 0 6px; cursor: pointer; color: #6c757d;
        }
        .recaptcha-align { display: flex; justify-content: center; margin-top: .75rem; }
        html, body.login-bg { height: 100%; }
        body.login-bg{
            min-height: 100vh;
            background: url('<?= h($bg) ?>') no-repeat center center fixed;
            background-size: cover;
        }
        body.login-bg::before{
            content: "";
            position: fixed; inset: 0;
            background: radial-gradient(circle at 50% 40%,
            rgba(255,255,255,.70) 0%,
            rgba(255,255,255,.50) 40%,
            rgba(255,255,255,.30) 100%);
            pointer-events: none;
        }
        .card{
            background: rgba(255,255,255,.88);
            backdrop-filter: blur(3px);
            -webkit-backdrop-filter: blur(3px);
        }
        .login-shell{
            min-height: 100vh;
            display: flex; align-items: center; justify-content: center;
        }
        .country-dropdown .select2-results__options {
            max-height: 20em !important; /* Adjust if needed */
            overflow-y: auto;
        }

        .pw-rules li { display: flex; align-items: center; margin-bottom: 2px; }
        .pw-rules li i { margin-right: 6px; }
        .pw-rules .pw-ok { color: #28a745; }   /* green */
        .pw-rules .pw-bad { color: #df0026; }  /* red */
    </style>

</head>

<body class="login-bg">
<div class="container mt-5" style="max-width:440px">
    <div class="card">
        <div class="card-body p-4">

            <!-- LOGIN FORM -->
            <div id="login-form-container">
                <h4 class="mb-3">
                    Login to <span style="color: dodgerblue;">Smart Clinic Flow</span>
                </h4>
                <?= $this->Flash->render() ?>

                <?= $this->Form->create(null, [
                    'id'          => 'login-form',
                    'url'         => '/',
                    'type'        => 'post',
                    'autocomplete' => 'off',
                ]) ?>

                <?php $this->Form->unlockField('g-recaptcha-response'); ?>

                <div class="form-group mb-3">
                    <label for="email">Email</label>
                    <?= $this->Form->control('email', [
                        'type' => 'email',
                        'id' => 'email',
                        'label' => false,
                        'class' => 'form-control',
                        'autofocus' => true,
                        'maxlength' => 40,
                        'templates' => ['inputContainer' => '{{content}}'],
                    ]) ?>
                </div>

                <div class="form-group mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <label for="password" class="mb-0">Password</label>
                        <a href="<?= $this->Url->build('/forgot') ?>" class="text-small">Reset Password?</a>
                    </div>

                    <div class="password-wrapper">
                        <?= $this->Form->control('password', [
                            'type' => 'password',
                            'id' => 'password',
                            'label' => false,
                            'class' => 'form-control',
                            'autocomplete' => 'current-password',
                            'maxlength' => 50,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                        <button type="button" class="password-toggle" data-target="#password" aria-label="Show password">
                            <i class="far fa-eye"></i>
                        </button>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <div class="custom-control custom-checkbox">
                        <?= $this->Form->checkbox('remember', [
                            'id' => 'remember-me',
                            'class' => 'custom-control-input',
                            'templates' => ['checkboxContainer' => '{{content}}'],
                        ]) ?>
                        <label class="custom-control-label mb-2" for="remember-me">Remember Me</label>
                    </div>
                </div>

                <script src="https://www.google.com/recaptcha/api.js?hl=en" async defer></script>
                <div class="recaptcha-align">
                    <div class="g-recaptcha" data-sitekey="6Le6pqQrAAAAAD-rDIzxCpNMOyKnpNsDL8bi7eh9"></div>
                </div>


                <div class="form-group mb-2 mt-4">
                    <?= $this->Form->button('Login', ['class' => 'btn btn-primary btn-lg w-100']) ?>
                </div>
                <?= $this->Form->end() ?>
                <hr style="border: none; border-top: 1px solid #ccc; margin: 1em 0;">
                <div class="text-center mt-3">
                    Not registered? <a href="#" id="show-register">Register here</a>
                </div>
            </div>






            <!-- Hidden register form (shows upon user clicking 'Register Here' link-->
            <div id="register-form-container" style="display:none;"> <!-- initially hidden -->
                <h4 class="mb-3">
                    Register for <span style="color: dodgerblue;">Smart Clinic Flow</span>
                </h4>
                <div class="mb-4 mt-4">Create an Administrator account to manage your clinic.</div>
                <?= $this->Form->create(null, [
                    'id'  => 'register-form',
                    'url' => ['controller' => 'Login', 'action' => 'registerClinic'],
                    'type' => 'post',
                ]) ?>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="first_name">First Name</label>
                        <?= $this->Form->control('first_name', [
                            'type' => 'text',
                            'id' => 'first_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'maxlength' => 30,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="last_name">Last Name</label>
                        <?= $this->Form->control('last_name', [
                            'type' => 'text',
                            'id' => 'last_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'maxlength' => 30,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="register-email">Email</label>
                    <?= $this->Form->control('email', [
                        'type' => 'email',
                        'id' => 'register-email',
                        'label' => false,
                        'class' => 'form-control',
                        'maxlength' => 40,
                        'templates' => ['inputContainer' => '{{content}}'],
                    ]) ?>
                </div>

                <div class="form-group mb-3">
                        <?= $this->Form->label('mobile_phone', 'Mobile Phone') ?>
                        <?= $this->Form->text('mobile_phone', [
                            'id' => 'mobile_phone',
                            'class' => 'form-control',
                            'required' => true,
                            'placeholder' => 'Enter 10-digit number',
                            'pattern' => '^\d{10}$', // exactly 10 digits
                            'maxlength' => 10,
                            'title' => 'Enter exactly 10 digits'
                        ]) ?>
                        <div class="invalid-feedback">Enter a valid phone number (e.g. +61 xxx xxx xxx).</div>
                </div>

                <div class="form-group mb-3 row">
                    <div class="col">
                        <label for="register-password">Password</label>
                        <div class="password-wrapper">
                            <?= $this->Form->control('password', [
                                'type' => 'password',
                                'id' => 'register-password',
                                'label' => false,
                                'class' => 'form-control',
                                'required' => true,
                                'maxlength' => 50,
                                'templates' => ['inputContainer' => '{{content}}']
                            ]) ?>
                            <button type="button" class="password-toggle" data-target="#register-password" aria-label="Show password">
                                <i class="far fa-eye"></i>
                            </button>
                        </div>

                        <ul class="pw-rules" id="registerPwRules" style="margin:6px 0 0 0; padding-left:22px; list-style:none;">
                            <li id="register-rule-length" class="pw-bad"><i class="far fa-dot-circle"></i> At least 8 characters</li>
                            <li id="register-rule-upper" class="pw-bad"><i class="far fa-dot-circle"></i> At least 1 uppercase letter</li>
                            <li id="register-rule-number" class="pw-bad"><i class="far fa-dot-circle"></i> At least 1 number</li>
                        </ul>
                        <div id="registerPwFeedback" class="invalid-feedback" style="display:block;"></div>
                    </div>
                </div>



                <div class="form-group mb-2">
                    <?= $this->Form->button('Register', ['class' => 'btn btn-success btn-lg w-100']) ?>
                </div>
                <?= $this->Form->end() ?>
                <hr style="border: none; border-top: 1px solid #ccc; margin: 1em 0;">
                <div class="text-center mt-3">
                    Already registered? <a href="#" id="show-login">Back to Login</a>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    // Toggle forms
    document.getElementById("show-register").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("login-form-container").style.display = "none";
        document.getElementById("register-form-container").style.display = "block";
    });

    document.getElementById("show-login").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("register-form-container").style.display = "none";
        document.getElementById("login-form-container").style.display = "block";
    });

    // Password toggle
    document.addEventListener('click', function (e) {
        const btn = e.target.closest('.password-toggle');
        if (!btn) return;
        const input = document.querySelector(btn.dataset.target);
        if (!input) return;

        const shown = input.type === 'text';
        input.type = shown ? 'password' : 'text';
        btn.setAttribute('aria-label', shown ? 'Show password' : 'Hide password');

        const icon = btn.querySelector('i');
        if (icon) { icon.classList.toggle('fa-eye'); icon.classList.toggle('fa-eye-slash'); }
    }, false);

</script>
<script>
    (function() {
        const pwd = document.getElementById('register-password');
        if (!pwd) return;

        const rules = {
            len: document.getElementById('register-rule-length'),
            upper: document.getElementById('register-rule-upper'),
            number: document.getElementById('register-rule-number')
        };
        const feedback = document.getElementById('registerPwFeedback');

        function toggleRule(el, ok) {
            if (!el) return;
            el.classList.toggle('pw-ok', ok);
            el.classList.toggle('pw-bad', !ok);
            const icon = el.querySelector('i');
            if (icon) {
                icon.classList.toggle('fa-check-circle', ok);
                icon.classList.toggle('fa-dot-circle', !ok);
            }
        }

        function validatePassword() {
            const val = pwd.value;
            toggleRule(rules.len, val.length >= 8);
            toggleRule(rules.upper, /[A-Z]/.test(val));
            toggleRule(rules.number, /\d/.test(val));
        }

        pwd.addEventListener('input', validatePassword);

        // Optional: Show/hide password toggle
        // const toggleBtn = document.createElement('button');
        // toggleBtn.type = 'button';
        // toggleBtn.className = 'password-toggle';
        // toggleBtn.style.position = 'absolute';
        // toggleBtn.style.right = '10px';
        // toggleBtn.style.top = '50%';
        // toggleBtn.style.transform = 'translateY(-50%)';
        // toggleBtn.innerHTML = '<i class="far fa-eye"></i>';
        // toggleBtn.setAttribute('aria-label', 'Show password');
        //
        // const wrapper = pwd.closest('.col');
        // wrapper.style.position = 'relative';
        // wrapper.appendChild(toggleBtn);
        //
        // toggleBtn.addEventListener('click', function() {
        //     const shown = pwd.type === 'text';
        //     pwd.type = shown ? 'password' : 'text';
        //     toggleBtn.querySelector('i').classList.toggle('fa-eye', shown);
        //     toggleBtn.querySelector('i').classList.toggle('fa-eye-slash', !shown);
        // });

    })();
</script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.country-select').select2({
            width: '100%',
            placeholder: 'Select a country...',
            dropdownCssClass: 'country-dropdown'
        });
    });
</script>
<script>
    (function () {
        const limits = [
            { id: 'email',              max: 40, msg: 'Username has reached the 40-character limit.' },
            { id: 'register-email',     max: 40, msg: 'Username has reached the 40-character limit.' },
            { id: 'password',           max: 50, msg: 'Password has reached the 50-character limit.' },
            { id: 'register-password',  max: 50, msg: 'Password has reached the 50-character limit.' },
            { id: 'first_name',         max: 30, msg: 'First name has reached the 30-character limit.' },
            { id: 'last_name',          max: 30, msg: 'Last name has reached the 50-character limit.' },
            { id: 'mobile_phone',       max: 10, msg: 'Mobile phone has reached the 50-character limit.' },
        ];

        function ensureHint(input) {
            let host = input.closest('.password-wrapper') || input.parentElement || input;
            let hint = host.querySelector('.__len-hint');
            if (!hint) {
                hint = document.createElement('div');
                hint.className = '__len-hint';
                hint.style.cssText = 'margin-top:6px;font-size:.875rem;display:none;color:#dc3545;';
                host.appendChild(hint);
            }
            return hint;
        }

        function isPrintableKey(e) {
            if (e.ctrlKey || e.metaKey || e.altKey) return false;
            const code = e.key || '';
            const non = ['Backspace','Delete','Tab','Enter','Escape','ArrowLeft','ArrowRight','ArrowUp','ArrowDown','Home','End'];
            if (non.includes(code)) return false;
            return code.length === 1;
        }

        function bindLimit({ id, max, msg }) {
            const el = document.getElementById(id);
            if (!el) return;

            el.setAttribute('maxlength', String(max));

            const hint = ensureHint(el);

            function show(text) {
                hint.textContent = text;
                hint.style.display = 'block';
                el.classList.add('is-invalid');
                el.style.animation = 'blink .14s 2';
                setTimeout(()=>{ el.style.animation = ''; }, 300);
            }
            function hide() {
                hint.style.display = 'none';
                el.classList.remove('is-invalid');
            }

            function update() {
                const len = (el.value || '').length;
                if (len >= max) show(msg);
                else hide();
            }

            function onKeyDown(e) {
                const len = (el.value || '').length;
                const hasSelection = el.selectionEnd > el.selectionStart;
                if (len >= max && !hasSelection && isPrintableKey(e)) {
                    show(msg);
                }
            }

            el.addEventListener('input',  update);
            el.addEventListener('blur',   update);
            el.addEventListener('paste',  () => setTimeout(update, 0));
            el.addEventListener('keydown', onKeyDown);

            update();
        }

        const style = document.createElement('style');
        style.textContent = '@keyframes blink{from{box-shadow:0 0 0 0 rgba(220,53,69,.35)}to{box-shadow:0 0 0 .5rem rgba(220,53,69,0)}}';
        document.head.appendChild(style);

        limits.forEach(bindLimit);
    })();
</script>


</body>
</html>
