<?php
/**
 * @var object|null $alert
 */
if (!$alert) return;

$color   = $alert->color_hex ?: '#D91F1F';
$sev     = ucfirst((string)($alert->severity ?: 'danger'));
$text    = (string)($alert->text ?: '');
$starts  = $alert->starts_at ? $alert->starts_at->i18nFormat('dd-MMM-yyyy HH:mm') : null;
$ends    = $alert->ends_at   ? $alert->ends_at->i18nFormat('dd-MMM-yyyy HH:mm') : null;
?>
<div class="pa-alert-banner" role="alert" aria-live="polite">
    <div class="pa-alert-icon" style="color:<?= h($color) ?>">⚠</div>
    <div class="pa-alert-body">
        <div class="pa-alert-text"><?= nl2br(h($text)) ?></div>
        <div class="pa-alert-meta text-muted small">
            <span class="badge badge-light text-uppercase mr-2"><?= h($sev) ?></span>
            <?php if ($starts): ?>Start: <?= h($starts) ?><?php endif; ?>
            <?php if ($ends): ?> · End: <?= h($ends) ?><?php endif; ?>
            <?php if (!empty($alert->is_dismissible)): ?>
                <span class="badge badge-light ml-2">Dismissible</span>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .pa-alert-banner{
        display:flex; align-items:flex-start; gap:12px;
        background:#fee2e2; border:1px solid #fecaca; border-radius:12px;
        padding:14px 16px; margin-bottom:16px;
    }
    .pa-alert-icon{ font-size:20px; line-height:1; margin-top:2px; }
    .pa-alert-text{ font-weight:600; color:#991b1b; }
</style>
