<?php
use Cake\Core\Configure;
$bg = $this->Url->assetUrl('img/login/background.jpg', ['fullBase' => false]);
?>
<!doctype html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>[DEV] <?= h($this->fetch('title') ?: 'Error') ?> · <?= h(env('APP_NAME') ?: 'Application') ?></title>
    <style>
        :root{
            --bg:#f7f9fc; --card:#ffffff; --muted:#667085; --text:#101828; --accent:#2e7cf6; --accent-weak:#e7f0ff;
            --border:#e5e7eb; --shadow:0 8px 28px rgba(16,24,40,.08); --divider:#eef2f6; --brand:#98a2b3;
        }
        *{ box-sizing:border-box; }
        html,body{ height:100%; }
        body{
            margin:0;
            font-family: Inter,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
            color:var(--text);
            display:flex; align-items:center; justify-content:center;
            padding:24px;
            min-height:100dvh;

            background-image: url('<?= h($bg) ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            position: relative;
        }
        body::before{
            content:"";
            position:fixed; inset:0;
            background: linear-gradient(to bottom, rgba(255,255,255,.05), rgba(255,255,255,.05));
            pointer-events:none;
            z-index:0;
        }

        .wrap{
            position:relative; z-index:1;
            width:100%; max-width:880px; background:var(--card);
            border:1px solid var(--border); border-radius:16px; box-shadow:var(--shadow); overflow:hidden;
        }
        .header{ padding:18px 22px; display:flex; gap:12px; align-items:center; border-bottom:1px solid var(--divider);
            background:linear-gradient(180deg, #fff 0%, #fffaf1 100%); }
        .badge{ padding:4px 10px; border-radius:999px; font-size:12px; background:var(--accent); color:#1a1a1a; font-weight:800;}
        .brand{ margin-left:auto; color:#98a2b3; font-size:12px; }
        .body{ padding:26px 22px; }
        h1{ margin:0 0 12px; font-size:24px; }
        p{ color:var(--muted); margin:8px 0; }
        .panel{ margin-top:16px; padding:14px 16px; background:#fffbea; border:1px dashed #f3d280; border-radius:12px; color:#7a5b00; }
        .grid{ display:grid; grid-template-columns:1fr; gap:10px; }
        pre{ margin:0; overflow:auto; max-height:320px; background:#f8fafc; border:1px solid var(--border); padding:12px; border-radius:10px; color:#24292f; }
        .actions{ display:flex; gap:10px; margin-top:18px; flex-wrap:wrap; }
        .btn{ appearance:none; border:none; cursor:pointer; text-decoration:none; padding:10px 14px; border-radius:10px;
            font-weight:600; font-size:14px; background:#f3f5f9; color:#0f172a; border:1px solid var(--border);}
        .btn-primary{ background:#2e7cf6; color:#fff; border-color:#2a6fe0; }
        footer{ padding:12px 22px; border-top:1px solid var(--divider); color:#667085; font-size:12px; background:#fff; }
        @media (min-width:900px){ .grid{ grid-template-columns:1fr 1fr; } }
        @media (max-width:600px){ .header,.body,footer{ padding:16px; } }
    </style>
</head>
<body>
<main class="wrap" role="main" aria-label="Error (dev)">
    <div class="header">
        <span class="badge">DEV ERROR</span>
        <div>
            <div style="font-weight:800;"><?= h($this->fetch('title') ?: 'An error occurred') ?></div>
            <?php if ($tpl = $this->fetch('templateName')): ?>
                <div style="opacity:.7;font-size:12px;">Template: <?= h($tpl) ?></div>
            <?php endif; ?>
        </div>
        <div class="brand"><?= h(env('APP_NAME') ?: 'Application') ?></div>
    </div>

    <div class="body">
        <?= $this->fetch('content') ?>

        <?php if ($file = trim((string)$this->fetch('file'))): ?>
            <div class="panel"><?= $file ?></div>
        <?php endif; ?>

        <div class="panel" style="background:#f6faff;border-color:#d5e3ff;color:#1e3a8a;">
            <strong>Environment &amp; Request</strong>
            <div class="grid" style="margin-top:10px;">
                <div>
                    <div style="opacity:.8;margin-bottom:6px;">Request</div>
                    <pre><?= h(print_r([
                            'method' => $this->getRequest()->getMethod(),
                            'url'    => (string)$this->getRequest()->getUri(),
                            'params' => $this->getRequest()->getAttribute('params'),
                            'query'  => $this->getRequest()->getQueryParams(),
                        ], true)) ?></pre>
                </div>
                <div>
                    <div style="opacity:.8;margin-bottom:6px;">Config</div>
                    <pre><?= h(print_r([
                            'app'     => env('APP_NAME') ?: null,
                            'env'     => env('APP_ENV') ?: null,
                            'debug'   => (bool)Configure::read('debug'),
                            'php'     => PHP_VERSION,
                            'cakephp' => \Cake\Core\Configure::version() ?? null,
                        ], true)) ?></pre>
                </div>
            </div>
        </div>

        <div class="actions">
            <a class="btn btn-primary" href="<?= $this->Url->build('/') ?>">Home</a>
            <a class="btn" href="javascript:history.back()" rel="nofollow">Back</a>
        </div>
    </div>

    <footer>
        <span>Status: <?= (int)($this->getResponse()?->getStatusCode() ?? 500) ?></span>
        <span>·</span>
        <span>Time: <?= h(date('Y-m-d H:i:s')) ?></span>
        <span>·</span>
        <span>Debug: on</span>
    </footer>
</main>
</body>
</html>
