<?php $bg = $this->Url->assetUrl('img/login/background.jpg', ['fullBase' => false]);
?>

<!doctype html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= h($this->fetch('title') ?: 'Error') ?> · <?= h(env('APP_NAME') ?: 'Application') ?></title>
    <style>
        :root{
            --bg:#f7f9fc; --card:#ffffff; --muted:#667085; --text:#101828; --accent:#2e7cf6; --accent-weak:#e7f0ff;
            --border:#e5e7eb; --shadow:0 8px 28px rgba(16,24,40,.08); --divider:#eef2f6; --brand:#98a2b3;
        }
        *{ box-sizing:border-box; }
        html,body{ height:100%; }
        body{
            margin:0;
            font-family: Inter,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
            color:var(--text);
            display:flex; align-items:center; justify-content:center;
            padding:24px;
            min-height:100dvh;

            background-image: url('<?= h($bg) ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            position: relative;
        }
        body::before{
            content:"";
            position:fixed; inset:0;
            background: linear-gradient(to bottom, rgba(255,255,255,.05), rgba(255,255,255,.05));
            pointer-events:none;
            z-index:0;
        }

        .wrap{
            position:relative; z-index:1;
            width:100%; max-width:880px; background:var(--card);
            border:1px solid var(--border); border-radius:16px; box-shadow:var(--shadow); overflow:hidden;
        }
        .header{
            padding:18px 22px; display:flex; align-items:center; gap:12px;
            background:linear-gradient(180deg, #ffffff 0%, #fafbff 100%);
            border-bottom:1px solid var(--divider);
        }
        .badge{ padding:4px 10px; border-radius:999px; font-size:12px; font-weight:700;
            color:#0b3b9c; background:var(--accent-weak); letter-spacing:.2px; }
        .brand{ margin-left:auto; color:var(--brand); font-size:12px; }
        .body{ padding:26px 22px; }
        h1{ margin:0 0 12px; font-size:24px; line-height:1.3; }
        p{ margin:8px 0; color:var(--muted); }
        .panel{
            margin-top:16px; padding:14px 16px; background:#fafafa; border:1px dashed var(--border);
            border-radius:12px; color:#475467;
        }
        .actions{ display:flex; gap:10px; margin-top:18px; flex-wrap:wrap; }
        .btn{
            appearance:none; border:none; cursor:pointer; text-decoration:none;
            padding:10px 14px; border-radius:10px; font-weight:600; font-size:14px;
            background:#f3f5f9; color:#0f172a; border:1px solid var(--border);
        }
        .btn:hover{ background:#eef2f7; }
        .btn-primary{ background:var(--accent); border-color:#2a6fe0; color:#fff; }
        .btn-primary:hover{ filter:brightness(1.03); }
        code,kbd{ background:#f2f4f7; border:1px solid var(--border); padding:2px 6px; border-radius:6px; color:#344054; }
        footer{
            display:flex; gap:8px; flex-wrap:wrap; align-items:center;
            padding:12px 22px; border-top:1px solid var(--divider); color:#667085; font-size:12px; background:#fff;
        }
        .file-block{ margin-top:6px; font-size:12px; color:#667085; }
        @media (max-width:600px){ .header,.body,footer{ padding:16px; } }
    </style>
</head>
<body>
<main class="wrap" role="main" aria-label="Error">
    <div class="header">
        <span class="badge">ERROR</span>
        <div>
            <div style="font-weight:700;"><?= h($this->fetch('title') ?: 'An error occurred') ?></div>
            <?php if ($tpl = $this->fetch('templateName')): ?>
                <div class="file-block">Template: <?= h($tpl) ?></div>
            <?php endif; ?>
        </div>
        <div class="brand"><?= h(env('APP_NAME') ?: 'Application') ?></div>
    </div>

    <div class="body">
        <?= $this->fetch('content') ?>

        <?php if ($file = trim((string)$this->fetch('file'))): ?>
            <div class="panel"><?= $file ?></div>
        <?php endif; ?>

        <div class="actions">
            <a class="btn btn-primary" href="<?= $this->Url->build('/') ?>">Go to Home</a>
            <a class="btn" href="javascript:history.back()" rel="nofollow">Go Back</a>
        </div>
    </div>

    <footer>
        <?php $code = (int)($this->getResponse()?->getStatusCode() ?? 500); ?>
        <span>Status: <?= $code ?></span>
        <span>·</span>
        <span>Time: <?= h(date('Y-m-d H:i:s')) ?></span>
        <span>·</span>
        <span>Request ID: <?= h($this->getRequest()->getEnv('UNIQUE_ID') ?: substr(hash('xxh128', microtime(true).random_int(1,PHP_INT_MAX)), 0, 12)) ?></span>
    </footer>
</main>
</body>
</html>
